<?php
// diag_login.php - diagnóstico para problemas de login / sessão / CSRF.
// Rode localmente, reveja os dados, não deixe este arquivo no servidor por muito tempo.

require_once __DIR__ . '/auth.php';

header('Content-Type: text/plain; charset=utf-8');

echo "=== DIAGNÓSTICO LOGIN ===\n\n";

// Mostrar caminho e permissão do users.json
echo "USERS_FILE: " . USERS_FILE . "\n";
echo "users.json existe: " . (file_exists(USERS_FILE) ? 'SIM' : 'NÃO') . "\n";
echo "users.json permissão (is_readable/is_writable): " . (is_readable(USERS_FILE) ? 'R' : '-') . '/' . (is_writable(USERS_FILE) ? 'W' : '-') . "\n\n";

// Mostrar o usuário admin (se existir)
$users = load_users();
$admin = null;
foreach ($users as $u) {
    if (isset($u['username']) && strtolower($u['username']) === 'admin') { $admin = $u; break; }
}
echo "Admin encontrado: " . ($admin ? 'SIM' : 'NÃO') . "\n";
if ($admin) {
    echo " admin.id: " . ($admin['id'] ?? '-') . "\n";
    echo " admin.email: " . ($admin['email'] ?? '-') . "\n";
    echo " admin.active: " . (!empty($admin['active']) ? 'true' : 'false') . "\n";
    echo " admin.role: " . ($admin['role'] ?? '-') . "\n";
    echo " admin.password_hash: " . ($admin['password_hash'] ?? '-') . "\n";
    // Teste rápido do hash
    echo " password_verify('admin', hash): " . (isset($admin['password_hash']) && password_verify('admin', $admin['password_hash']) ? 'true' : 'false') . "\n";
}
echo "\n";

// Sessão / CSRF
echo "Session status: " . session_status() . " (1=disabled, 2=none, 3=active)\n";
echo "Session id (from PHP): " . session_id() . "\n";
echo "Session save path (php): " . (ini_get('session.save_path') ?: '(não definido)') . "\n";
echo "CSRF token in session: " . ($_SESSION['csrf_token'] ?? '(nenhum)') . "\n";
echo "\n";

// Se foi um POST, mostrar checagens
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "=== POST recebido ===\n";
    $posted = $_POST;
    echo "POST keys: " . implode(',', array_keys($posted)) . "\n";
    $posted_token = $_POST['csrf_token'] ?? '(nenhum)';
    echo "csrf_token (posted): $posted_token\n";
    echo "verify_csrf(posted): " . (verify_csrf($posted_token) ? 'true' : 'false') . "\n";

    $userOrEmail = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    echo "Tentativa login com: username/email='$userOrEmail' password='(omitted)'\n";
    $v = verify_user($userOrEmail, $password);
    if ($v === false) echo "verify_user: false (usuário/senha inválidos)\n";
    elseif ($v === 'blocked') echo "verify_user: bloqueado\n";
    else {
        echo "verify_user: OK - id=" . ($v['id'] ?? '-') . " username=" . ($v['username'] ?? '-') . " role=" . ($v['role'] ?? '-') . "\n";
    }
    echo "\n";
    exit; // para garantir que só essa saída seja exibida no POST
}

// Mostrar instruções para testar
echo "=== INSTRUÇÕES ===\n";
echo "1) Abra esta página (GET) e verifique 'Session id' e 'CSRF token in session'.\n";
echo "2) No navegador abra DevTools -> Application/Storage -> Cookies e verifique se cookie PHPSESSID foi definido.\n";
echo "3) Use o formulário abaixo (ou poste para login.php) e observe 'verify_csrf' e 'verify_user' no output.\n";
echo "\n";
?>
<html>
<body>
  <hr>
  <form method="post">
    <label>Usuário/Email: <input name="username" value="admin"></label><br>
    <label>Senha: <input name="password" value="admin" type="password"></label><br>
    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(csrf_token()); ?>">
    <button type="submit">Testar POST aqui</button>
  </form>
  <p style="color:orange">Depois de usar, REMOVA este arquivo do servidor.</p>
</body>
</html>